# Makefile for constructing publishable html file from source html
# files and a template.	 The variable SYSTEM-TEMPLATE
# should be passed as an argument to the make
# directive.  All .htm[l|x] files are dependent on the template.
#
# MODIFICATION HISTORY
# Mnemonic		Date	Rel Who
# www-publish	040615	1.0 mpw
#	Written.
# www-publish   050904  1.1 mpw
#   Add checking for valid XHTML (via chk_xhtml.py)
# www-publish   050909  1.2 mpw
#   Revised to handle XHTML conformant Docbook output
# www-publish   051001  1.3 mpw
#   SRC and OBJ dirctories passed on make invokation line
# www-publish   051101  1.4 mpw
#   remove created html file on error (ensures rebuild on next run)
#
# $Id: compile.mk,v 1.13 2014/06/04 08:52:28 mark Exp $

# set target directory
TD := ${subst ${SRC},${OBJ},${CURDIR}}

# most specific rules come first

# pattern rules for google generated files (don't template)
${TD}/google%.html : google%.html
	cp $< $@
	echo "  $< copied (not templated)"

${TD}/GOOGLE%.html : GOOGLE%.html
	cp $< $@
	echo "  $< copied (not templated)"

# define pattern rule for producing templated .html files with full
# checking in the target directory.
${TD}/%.html : %.html 
	echo -n "  $< :"; 
	${TOOLS-DIR}/create-html.py ${CREATE-ARGS} ${SRC}/${SYSTEM-TEMPLATE} \
		$< $@ || exit 1;
	${TOOLS-DIR}/chk_xml.py ${CHKXML-ARGS} $@ ##|| (rm $@; exit 1); 
	echo " OK"

# pattern rule for relaxed checking
${TD}/%.html : %.htmx 
	echo -n "  $< :"; 
	${TOOLS-DIR}/create-html.py ${CREATE-ARGS} ${SRC}/${SYSTEM-TEMPLATE} \
		$< $@ || exit 1; 
	${TOOLS-DIR}/chk_xhtml.py ${CHKXML-ARGS} $@ || (rm $@; exit 1);
	echo " OK (relaxed)";

# pattern rule to make non-html targets (images, support files, etc)
# note we ignore directories, as they have already been created
${TD}/% : %
	if [ ! -d $< ]; then \
		echo "  $< : copied" ; \
		cp $< $@; \
		chmod 644 $@; \
	fi

# define list of html template targets (based on list of .htm[l|x] files in 
# the current directory)
# strict checking
OBJS := ${patsubst %,${TD}/%,${wildcard *.html}}
# add in relaxed checking (convert target name to a .html suffix or pattern rule
# will not fire)
OBJS += ${patsubst %,${TD}/%.html,${subst .htmx,,${wildcard *.htmx}}}

# define list of non-htm[l|x] targets; include .htaccess files
OTHER := ${patsubst %,${TD}/%,${filter-out %.html %.htmx,${wildcard *}}}
OTHER += ${patsubst %,${TD}/%,${filter-out %.html %.htmx,${wildcard .??*}}}

all: ${TD} ${OBJS} ${OTHER}

# all htm[l|x] targets depend on the system template
${OBJS}: ${SRC}/${SYSTEM-TEMPLATE}

# make target directory if necessary
${TD}:
	mkdir -p ${TD}

